from sqlalchemy import Column, Integer, String, Float, ForeignKey, DateTime, Boolean
from database import Base
from sqlalchemy.sql import func

class Subscription(Base):
    __tablename__ = "subscriptions"

    id = Column(Integer, primary_key=True, index=True)
    name = Column(String(100), unique=True, nullable=False)
    description = Column(String(255))
    price = Column(Float, nullable=False)
    duration_days = Column(Integer, nullable=False)
    max_profile_views = Column(Integer, nullable=False)

    # ✅ NEW: Flag to identify trial plans
    is_trial = Column(Boolean, default=False)

class RecruiterSubscription(Base):
    __tablename__ = "recruiter_subscriptions"

    id = Column(Integer, primary_key=True, index=True)
    recruiter_id = Column(Integer, ForeignKey("users.id"))
    subscription_id = Column(Integer, ForeignKey("subscriptions.id"))
    start_date = Column(DateTime, default=func.now())
    end_date = Column(DateTime, nullable=False)
    is_active = Column(Boolean, default=True)
    views_used = Column(Integer, default=0)

