from sqlalchemy import Column, Integer, String, Date, Time
from database import Base

class Event(Base):
    __tablename__ = "events"
    id = Column(Integer, primary_key=True, index=True)
    event_name = Column(String(100), nullable=False)
    purpose = Column(String(100), nullable=False)  # e.g., interview, meeting, call offer
    date = Column(String(100), nullable=False)     # Store as String(100) (YYYY-MM-DD) or use Date
    start_time = Column(String(100), nullable=False)  # Store as String(100) (HH:MM) or use Time
    end_time = Column(String(100), nullable=False)