from pydantic import BaseModel, EmailStr
from typing import Optional

class StudentProfileUpdate(BaseModel):
    first_name: str
    last_name: str
    dob: Optional[str] = None
    gender: Optional[str] = None
    contact: Optional[str] = None
    address: Optional[str] = None
    education: Optional[str] = None
    email: EmailStr

class StudentProfileOut(BaseModel):
    id: int
    first_name: str
    last_name: str
    email: str
    contact: str | None = None
    address: str | None = None
    education: str | None = None
    profile_picture: str | None = None
    video_path: str | None = None

    class Config:
        orm_mode = True