from fastapi import FastAPI
from fastapi.middleware.cors import CORSMiddleware
from database import Base, engine
from routers.auth_routes import router as auth_router
from routers.recruiter_routes import router as recruiter_router
from routers.service_routes import router as service_router
from routers.student_chat_routes import router as student_chat_router
from models.models_profile_tables import RecruiterProfile, StudentProfile, AdminProfile
from routers.user_routes import router as user_router  # Add this import
from routers.events_routes import router as event_router
from routers.jobs_applied_user_routes import router as jobs_applied_router
from routers.api_routes import router as llm_settings_router
from routers import admin_subscription_routes
from routers import recruiter_profile_view_routes

from fastapi.staticfiles import StaticFiles
from starlette.middleware.sessions import SessionMiddleware

# Create all tables
Base.metadata.create_all(bind=engine)

app = FastAPI()
app.mount("/uploads", StaticFiles(directory="uploads"), name="uploads")
app.add_middleware(SessionMiddleware, secret_key="your-session-secret")

# ✅ Allow requests from frontend (adjust as needed)
app.add_middleware(
    CORSMiddleware,
    allow_origins=["*"],            # ✅ Add your frontend URL(s) here
    allow_credentials=True,
    allow_methods=["*"],
    allow_headers=["*"],
)

app.include_router(auth_router, prefix="/auth", tags=["Authentication"])
app.include_router(recruiter_router, prefix="/api", tags=["Recruiter"])
app.include_router(service_router, prefix="/api", tags=["Services"])
app.include_router(student_chat_router, prefix="/api", tags=["User Chat"])
app.include_router(service_router, prefix="/api", tags=["Services"])
app.include_router(user_router, prefix="/api", tags=["User"])  # Add this line
app.include_router(event_router, prefix="/api", tags=["Events"])
app.include_router(jobs_applied_router, prefix="/api", tags=["Job Applications"])
app.include_router(llm_settings_router, prefix="/api", tags=["LLM Settings"])
app.include_router(admin_subscription_routes.router, prefix="/api", tags=["Admin Subscription"])
app.include_router(recruiter_profile_view_routes.router, prefix="/api", tags=["Recruiter Profile Views"])