# database.py
from sqlalchemy import create_engine
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy.orm import sessionmaker, Session

# XAMPP MySQL connection
DATABASE_URL = "mysql+pymysql://root:@localhost/jobsy"

engine = create_engine(DATABASE_URL)
SessionLocal = sessionmaker(bind=engine, autocommit=False, autoflush=False)
Base = declarative_base()

# ✅ Add this function to enable dependency injection
def get_db():
    db: Session = SessionLocal()
    try:
        yield db
    finally:
        db.close()
